function [entities] = get_entities(geom, modelOpt)

%% evaluate entities

mech_domain = modelOpt.physics('solid').selection().inputEntities;
opt_domain = modelOpt.physics('emw').selection().inputEntities;
all_volume = intersect(mech_domain, opt_domain);

floquet_boundaries = [];
floquet_boundaries = [floquet_boundaries; modelOpt.physics('emw').feature('pc1').selection().inputEntities];

sym_boundary = [];
sym_boundary = [sym_boundary; modelOpt.physics('emw').feature('pmc1').selection().inputEntities];

d = 220e-9;
epsilon = 5e-9;

pol_x = geom.mech.amech/2 + ...
        [-geom.mech.bdd_width/2 -geom.mech.bdd_width/2 ...
        geom.mech.bdd_width/2 geom.mech.bdd_width/2 ...
        -geom.mech.bdd_width/2];
pol_y = geom.mech.mirror_y + [0 ...
    geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 ...
    0 0];

[pol_x_rot, pol_y_rot] = rotate(pol_x, pol_y, ...
    geom.mech.amech/2, 0, 60);
pol_x_rot = pol_x_rot + geom.mech.bdd_shift/2;
    pol_y_rot = pol_y_rot + geom.mech.bdd_shift*sqrt(3)/2;

coordBox = [min(pol_x_rot - epsilon), max(pol_x_rot + epsilon); ...
    min(pol_y_rot - epsilon), max(pol_y_rot + epsilon); ...
    -epsilon, d/2+epsilon];

all_boundaries = mphselectbox(modelOpt,'geom1',coordBox,'boundary',...
    'adjnumber', all_volume);
real_boundaries = setdiff(all_boundaries,floquet_boundaries);
real_boundaries = setdiff(real_boundaries,sym_boundary);

entities.acbeamSurf = real_boundaries;
entities.acbeamVol = all_volume;

end